/**
 * 
 */
package gov.va.med.mhv.sso.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.VirtualHostLocalService;
import com.liferay.portal.service.VirtualHostLocalServiceWrapper;

/**
 * @author DNS
 *
 */
public class MhvSSOeVirtualHostLocalServiceImpl extends VirtualHostLocalServiceWrapper {
	
	private static final Log LOG = LogFactoryUtil.getLog(MhvSSOeVirtualHostLocalServiceImpl.class);
	
	private static final String SSO_VIRTUAL_HOST_MAP_KEY = "sso.virtual.host.map[%s]";
	
	public MhvSSOeVirtualHostLocalServiceImpl(VirtualHostLocalService virtualHostLocalService) {
		super(virtualHostLocalService);
		
		LOG.info("Initializing MHV Custom SSOe Virtual Host Local Service implementation.");
	}
	
	@Override
	public VirtualHost fetchVirtualHost(String hostname) throws SystemException {
		
		VirtualHost vh = super.fetchVirtualHost(getMappedVirtualHostName(hostname));
		
		if(LOG.isDebugEnabled()) {
			LOG.debug(String.format("Returning Virtual Host: %s", vh.toString()));
		}
		
		return vh;
	}
	
	@Override
	public VirtualHost getVirtualHost(String hostname) throws PortalException, SystemException {
		
		VirtualHost vh = super.getVirtualHost(getMappedVirtualHostName(hostname));
		
		if(LOG.isDebugEnabled()) {
			LOG.debug(String.format("Returning Virtual Host: %s", vh.toString()));
		}
		return vh;
	}
	
	private String getMappedVirtualHostName(String requestedHostName) {
		String ssoVirtualHostKey = String.format(SSO_VIRTUAL_HOST_MAP_KEY, requestedHostName);
		
		if(LOG.isDebugEnabled()) {
			LOG.debug(String.format("SSO Virtual Host Map Key: '%s'", ssoVirtualHostKey));
			LOG.debug(String.format("Liferay Properties contains key: %b", PropsUtil.contains(ssoVirtualHostKey)));
		}
		
		String mappedHostName = (PropsUtil.contains(ssoVirtualHostKey)) ? PropsUtil.get(ssoVirtualHostKey) : requestedHostName;
		
		if(LOG.isDebugEnabled()) {
			LOG.debug(String.format("Host: '%s' maps to Liferay Virtual Host: '%s'.", requestedHostName, mappedHostName));
		}
		
		return mappedHostName;
	}
}
